/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.worldGeneration.chunkFileHandling.ChunkFileReader;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2861;
import net.minecraft.class_2867;
import org.jetbrains.annotations.Nullable;

public class RegionFileStorageExternalCache
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    @Nullable
    public final class_2867 storage;
    public static final int MAX_CACHE_SIZE = 16;
    public static boolean regionCacheNullPointerWarningSent = false;
    ReentrantLock getRegionFileLock = new ReentrantLock();
    private final ConcurrentLinkedQueue<RegionFileCache> regionFileCache = new ConcurrentLinkedQueue();

    public RegionFileStorageExternalCache(class_2867 storage) {
        this.storage = storage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public class_2861 getRegionFile(class_1923 chunkPos) throws IOException {
        if (this.storage == null) {
            if (!regionCacheNullPointerWarningSent) {
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. DH will be unable to access any Minecraft chunk data until said mod is removed.", new Object[0]);
            }
            return null;
        }
        long chunkPosLong = class_1923.method_8331((int)chunkPos.method_17885(), (int)chunkPos.method_17886());
        class_2861 regionFile = null;
        int retryCount = 0;
        int maxRetryCount = 8;
        while (retryCount < maxRetryCount) {
            ++retryCount;
            try {
                this.getRegionFileLock.lock();
                regionFile = (class_2861)this.storage.field_17657.getOrDefault(chunkPosLong, null);
                break;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            catch (NullPointerException e) {
                if (regionCacheNullPointerWarningSent) break;
                regionCacheNullPointerWarningSent = true;
                LOGGER.warn("Unable to access Minecraft's chunk cache. This may be due to another mod changing said cache. Falling back to DH's internal cache.", new Object[0]);
                break;
            }
            finally {
                this.getRegionFileLock.unlock();
            }
        }
        if (retryCount >= maxRetryCount) {
            ChunkFileReader.CHUNK_LOAD_LOGGER.warn("Concurrency issue detected when getting region file for chunk at [" + String.valueOf(chunkPos) + "].", new Object[0]);
        }
        if (regionFile != null) {
            return regionFile;
        }
        for (RegionFileCache cache : this.regionFileCache) {
            if (cache.pos != chunkPosLong) continue;
            return cache.file;
        }
        Path storageFolderPath = this.storage.field_18690;
        if (!Files.exists(storageFolderPath, new LinkOption[0])) {
            return null;
        }
        Path regionFilePath = storageFolderPath.resolve("r." + chunkPos.method_17885() + "." + chunkPos.method_17886() + ".mca");
        regionFile = new class_2861(regionFilePath, storageFolderPath, false);
        this.regionFileCache.add(new RegionFileCache(class_1923.method_8331((int)chunkPos.method_17885(), (int)chunkPos.method_17886()), regionFile));
        while (this.regionFileCache.size() > 16) {
            this.regionFileCache.poll().file.close();
        }
        return regionFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public class_2487 read(class_1923 pos) throws IOException {
        class_2861 file = this.getRegionFile(pos);
        if (file == null) {
            return null;
        }
        try (DataInputStream stream = file.method_21873(pos);){
            if (stream == null) {
                class_2487 class_24873 = null;
                return class_24873;
            }
            class_2487 class_24872 = class_2507.method_10627((DataInput)stream);
            return class_24872;
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        RegionFileCache cache;
        while ((cache = this.regionFileCache.poll()) != null) {
            cache.file.close();
        }
    }

    private static class RegionFileCache {
        public final long pos;
        public final class_2861 file;

        public RegionFileCache(long pos, class_2861 file) {
            this.pos = pos;
            this.file = file;
        }
    }
}

