/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.google.common.annotations.Beta;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.ColorStack;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TextScaleStack;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorDrawContext;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_898;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class TDrawContext
extends class_332 {
    private static final class_898 ERD = TCDCommonsClient.MC_CLIENT.method_1561();
    private static final class_4184 ERD_CAMERA = new class_4184();
    @Beta
    public static final int DEFAULT_TEXT_SIDE_OFFSET = 5;
    @Beta
    public static final int DEFAULT_TEXT_COLOR = 0xFFFFFF;
    @Beta
    public static final int DEFAULT_ERROR_COLOR = Color.MAGENTA.getRGB();
    @Beta
    public static final class_2960 TEXTURE_FILL = new class_2960(TCDCommons.getModID(), "textures/gui/fill.png");
    @Beta
    public static final class_2960 TEXTURE_ICONS = new class_2960(TCDCommons.getModID(), "textures/gui/icons.png");
    protected final ColorStack colorStack = new ColorStack();
    protected final TextScaleStack textScaleStack = new TextScaleStack();
    protected final class_310 client;
    @Nullable
    protected TParentElement currentTarget;
    public final int mouseX;
    public final int mouseY;
    public final float deltaTime;
    protected float textScale = 1.0f;

    protected TDrawContext(class_332 drawContext, int mouseX, int mouseY, float deltaTime) {
        this((AccessorDrawContext)drawContext, mouseX, mouseY, deltaTime);
    }

    private TDrawContext(AccessorDrawContext drawContext, int mouseX, int mouseY, float deltaTime) {
        super(drawContext.getClient(), drawContext.getVertexConsumers());
        AccessorDrawContext mixin_this = (AccessorDrawContext)((Object)this);
        mixin_this.setMatrices(drawContext.getMatrices());
        this.client = drawContext.getClient();
        this.currentTarget = null;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.deltaTime = deltaTime;
    }

    public static TDrawContext of(class_332 drawContext, int mouseX, int mouseY, float deltaTime) {
        return new TDrawContext(drawContext, mouseX, mouseY, deltaTime);
    }

    public final void updateContext(TParentElement target) {
        this.currentTarget = target;
    }

    public final void method_48196(class_1921 layer, int x1, int x2, int y1, int y2, int z, int color) {
        int i;
        if (x1 < y1) {
            i = x1;
            x1 = y1;
            y1 = i;
        }
        if (x2 < y2) {
            i = x2;
            x2 = y2;
            y2 = i;
        }
        ColorStack.Entry calc = this.colorStack.calculate();
        float a = (float)class_5253.class_5254.method_27762((int)color) / 255.0f * calc.a;
        float r = (float)class_5253.class_5254.method_27765((int)color) / 255.0f * calc.r;
        float g = (float)class_5253.class_5254.method_27766((int)color) / 255.0f * calc.g;
        float b = (float)class_5253.class_5254.method_27767((int)color) / 255.0f * calc.b;
        Matrix4f matrix4f = this.method_51448().method_23760().method_23761();
        class_4588 vertexConsumer = this.method_51450().getBuffer(layer);
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)x2, (float)z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)x1, (float)y2, (float)z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)y1, (float)y2, (float)z).method_22915(r, g, b, a).method_1344();
        vertexConsumer.method_22918(matrix4f, (float)y1, (float)x2, (float)z).method_22915(r, g, b, a).method_1344();
        RenderSystem.disableDepthTest();
        this.method_51450().method_22993();
        RenderSystem.enableDepthTest();
    }

    public final void pushTShaderColor(float red, float green, float blue, float alpha) {
        this.colorStack.push(red, green, blue, alpha);
        this.applyTShaderColor();
    }

    public final void pushTShaderColor(float red, float green, float blue, float alpha, ColorStack.BlendMethod blendMethod) {
        this.colorStack.push(red, green, blue, alpha, blendMethod);
        this.applyTShaderColor();
    }

    public final void popTShaderColor() {
        this.colorStack.pop();
        this.applyTShaderColor();
    }

    public final void applyTShaderColor() {
        this.colorStack.apply(this);
    }

    public final void method_51422(float red, float green, float blue, float alpha) {
        super.method_51422(red, green, blue, alpha);
    }

    public final void pushTTextScale(float scale) {
        this.textScaleStack.push(scale);
        this.applyTTextScale();
    }

    public final void popTTextScale() {
        this.textScaleStack.pop();
        this.applyTTextScale();
    }

    public final void applyTTextScale() {
        this.textScaleStack.apply(this);
    }

    public final void drawTElementTextTH(class_2561 text, HorizontalAlignment horizontalAlgnment) {
        this.drawTElementTextTHSC(text, horizontalAlgnment, 5, 0xFFFFFF);
    }

    public final void drawTElementTextTHC(class_2561 text, HorizontalAlignment horizontalAlgnment, int color) {
        this.drawTElementTextTHSC(text, horizontalAlgnment, 5, color);
    }

    public final void drawTElementTextTHSC(class_2561 text, HorizontalAlignment horizontalAlgnment, int sideOffset, int color) {
        this.drawTElementTextTHSCS(text, horizontalAlgnment, sideOffset, color, 1.0f);
    }

    public final void drawTElementTextTHSS(class_2561 text, HorizontalAlignment horizontalAlgnment, int sideOffset, float textScale) {
        this.drawTElementTextTHSCS(text, horizontalAlgnment, sideOffset, 0xFFFFFF, textScale);
    }

    public final void drawTElementTextTHSCS(class_2561 text, HorizontalAlignment horizontalAlgnment, int sideOffset, int color, float textScale) {
        double textX;
        if (text == null || horizontalAlgnment == null) {
            return;
        }
        textScale *= this.textScale;
        class_327 txtR = this.client.field_1772;
        int textWidth = txtR.method_27525((class_5348)text);
        int targetCenter = this.currentTarget.getY() + this.currentTarget.getHeight() / 2;
        float f = targetCenter;
        Objects.requireNonNull(txtR);
        double textY = f - 9.0f * textScale / 2.0f;
        switch (horizontalAlgnment) {
            case LEFT: {
                textX = this.currentTarget.getX() + sideOffset;
                break;
            }
            case RIGHT: {
                textX = (float)this.currentTarget.getEndX() - ((float)textWidth * textScale + (float)sideOffset);
                break;
            }
            case CENTER: {
                textX = this.currentTarget.getX() + this.currentTarget.getWidth() / 2;
                textX -= (double)((float)textWidth * textScale / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected " + HorizontalAlignment.class.getSimpleName() + ".");
            }
        }
        this.method_51448().method_22903();
        this.method_51448().method_22904(textX, textY, 0.0);
        this.method_51448().method_22905(textScale, textScale, 1.0f);
        this.method_27535(txtR, text, 0, 0, color);
        this.method_51448().method_22909();
    }

    public final void drawTBorder(int color) {
        this.method_49601(this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getWidth(), this.currentTarget.getHeight(), color);
    }

    public final void drawTFill(int color) {
        this.method_25294(this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getEndX(), this.currentTarget.getEndY(), color);
    }

    public final void drawTNineSlicedTexture(class_2960 textureId, int u, int v, int regionWidth, int regionHeight, int slicedBorderSize) {
        this.drawTNineSlicedTexture(textureId, u, v, regionWidth, regionHeight, 256, 256, slicedBorderSize);
    }

    public final void drawTNineSlicedTexture(class_2960 textureId, int u, int v, int uvW, int uvH, int tW, int tH, int s) {
        this.drawTNineSlicedTexture(textureId, this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getWidth(), this.currentTarget.getHeight(), u, v, uvW, uvH, tW, tH, s);
    }

    public final void drawTNineSlicedTexture(class_2960 textureId, int x, int y, int w, int h, int u, int v, int uvW, int uvH, int tW, int tH, int s) {
        int s2 = s * 2;
        if (s2 < w || s2 < h) {
            this.method_25293(textureId, x, y, s, s, u, v, s, s, tW, tH);
            this.method_25293(textureId, x + w - s, y, s, s, u + uvW - s, v, s, s, tW, tH);
            this.method_25293(textureId, x, y + h - s, s, s, u, v + uvH - s, s, s, tW, tH);
            this.method_25293(textureId, x + w - s, y + h - s, s, s, u + uvW - s, v + uvH - s, s, s, tW, tH);
            this.method_25293(textureId, x + s, y, w - s2, s, u + s, v, uvW - s2, s, tW, tH);
            this.method_25293(textureId, x, y + s, s, h - s2, u, v + s, s, uvH - s2, tW, tH);
            this.method_25293(textureId, x + w - s, y + s, s, h - s2, u + uvW - s, v + s, s, uvH - s2, tW, tH);
            this.method_25293(textureId, x + s, y + h - s, w - s2, s, u + s, v + uvH - s, uvW - s2, s, tW, tH);
            this.drawTRepeatingTexture(textureId, x + s, y + s, w - s2, h - s2, u + s, v + s, uvW - s2, uvH - s2, tW, tH);
        } else {
            this.method_25293(textureId, x, y, w, h, u, v, uvW, uvH, tW, tH);
        }
    }

    public final void drawTRepeatingTexture(class_2960 textureId, int x, int y, int width, int height, int u, int v, int uvRegionWidth, int uvRegionHeight, int textureWidth, int textureHeight) {
        int endX = x + width;
        int endY = y + height;
        for (int y1 = y; y1 < endY; y1 += uvRegionHeight) {
            for (int x1 = x; x1 < endX; x1 += uvRegionWidth) {
                int nextW = uvRegionWidth;
                int nextH = uvRegionHeight;
                if (x1 + nextW > endX) {
                    nextW -= x1 + nextW - endX;
                }
                if (y1 + nextH > endY) {
                    nextH -= y1 + nextH - endY;
                }
                if (nextW < 1 || nextH < 1) continue;
                this.method_25293(textureId, x1, y1, nextW, nextH, u, v, nextW, nextH, textureWidth, textureHeight);
            }
        }
    }

    public final void drawTButton(int yImage) {
        this.drawTNineSlicedTexture(class_339.field_22757, 0, yImage, 200, 20, 3);
    }

    @ApiStatus.Experimental
    public final void drawTEntity(class_1297 entity, int size, boolean followCursor) throws NullPointerException {
        if (entity == null) {
            return;
        }
        TParentElement c = this.currentTarget;
        this.drawTEntity(entity, c.getX(), c.getY(), size, followCursor);
    }

    @ApiStatus.Experimental
    public final void drawTEntity(class_1297 entity, int x, int y, int size, boolean followCursor) {
        class_1309 livingEntity;
        if (entity == null) {
            return;
        }
        int mouseX = followCursor ? this.mouseX + size / 2 : x + 100;
        int mouseY = followCursor ? this.mouseY + size / 2 : y + 50;
        class_1309 class_13092 = livingEntity = entity instanceof class_1309 ? (class_1309)entity : null;
        if (livingEntity != null && TCDCommonsClient.MC_CLIENT.field_1687 != null) {
            class_490.method_2486((class_332)this, (int)x, (int)y, (int)size, (float)(x - mouseX), (float)(y - mouseY), (class_1309)livingEntity);
            return;
        }
        float atanMouseX40 = (float)Math.atan((float)(mouseX - x) / 40.0f);
        float atanMouseY40 = -((float)Math.atan((float)(mouseY - y) / 40.0f));
        Quaternionf quaternionf = new Quaternionf().rotateZ((float)Math.PI).rotateY((float)Math.PI);
        Quaternionf quaternionf2 = new Quaternionf().rotateX(atanMouseY40 * 20.0f * ((float)Math.PI / 180));
        quaternionf.mul((Quaternionfc)quaternionf2);
        float i = entity.method_36454();
        float j = entity.method_36455();
        entity.method_36456(180.0f + atanMouseX40 * 40.0f);
        entity.method_36457(-atanMouseY40 * 20.0f);
        float h = 0.0f;
        float k = 0.0f;
        float l = 0.0f;
        if (livingEntity != null) {
            h = livingEntity.field_6283;
            k = livingEntity.field_6259;
            l = livingEntity.field_6241;
            livingEntity.field_6283 = 180.0f + atanMouseX40 * 20.0f;
            livingEntity.field_6241 = entity.method_36454();
            livingEntity.field_6259 = entity.method_36454();
        }
        this.__drawTEntity(x, y, size, quaternionf, quaternionf2, entity);
        entity.method_36456(i);
        entity.method_36457(j);
        if (livingEntity != null) {
            livingEntity.field_6283 = h;
            livingEntity.field_6259 = k;
            livingEntity.field_6241 = l;
        }
    }

    @ApiStatus.Internal
    private final void __drawTEntity(int x, int y, int size, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1297 entity) {
        class_4587 matrices = this.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)x, (float)y, 50.0f);
        matrices.method_34425(new Matrix4f().scaling((float)size, (float)size, (float)size));
        matrices.method_22907(quaternionf);
        class_308.method_34742();
        if (quaternionf2 != null) {
            quaternionf2.conjugate();
            ERD.method_24196(quaternionf2);
        }
        if (TDrawContext.ERD.field_4686 == null) {
            TDrawContext.ERD.field_4686 = ERD_CAMERA;
        }
        ERD.method_3948(false);
        ERD.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, this.method_51448(), (class_4597)this.method_51450(), 0xF000F0);
        this.method_51452();
        ERD.method_3948(true);
        matrices.method_22909();
        class_308.method_24211();
    }
}

