/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.sounds;

import com.google.common.collect.Maps;
import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.debug.DebugUtils;
import dev.arbor.extrasoundsnext.mapping.SoundPackLoader;
import dev.arbor.extrasoundsnext.sounds.Mixers;
import dev.arbor.extrasoundsnext.sounds.SoundType;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1291;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4081;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SoundManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final class_5819 MC_RANDOM = class_5819.method_43047();
    private static final BiPredicate<class_1713, Integer> RIGHT_CLICK_PREDICATE = (actionType, button) -> actionType != class_1713.field_7795 && actionType != class_1713.field_7791 && button == 1 || actionType == class_1713.field_7789 && class_1703.method_7620((int)button) == 1;
    private static final Map<class_1792, BiPredicate<class_1713, Integer>> IGNORE_SOUND_PREDICATE_MAP = (Map)class_156.method_654((Object)Maps.newHashMap(), map -> map.put(class_1802.field_27023, RIGHT_CLICK_PREDICATE));
    private static long lastPlayed = 0L;
    private static class_1792 quickMovingItem = class_1802.field_8162;

    public static void hotbar(int i) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_1799 stack = player.method_31548().method_5438(i);
        if (stack.method_7909() == class_1802.field_8162) {
            SoundManager.playSound(Sounds.HOTBAR_SCROLL, SoundType.HOTBAR, Mixers.EMPTY_HOTBAR);
        } else {
            SoundManager.playSound(stack, SoundType.HOTBAR);
        }
    }

    public static void inventoryClick(class_1799 inSlot, class_1799 onCursor, class_1713 actionType) {
        boolean hasSlot;
        boolean hasCursor = !onCursor.method_7960();
        boolean bl = hasSlot = !inSlot.method_7960();
        if (!hasCursor && !hasSlot) {
            return;
        }
        switch (actionType) {
            case field_7793: {
                if (!hasCursor || onCursor.method_7947() >= onCursor.method_7914()) break;
                SoundManager.playSound(Sounds.ITEM_PICK_ALL, SoundType.PICKUP);
                break;
            }
            case field_7795: {
                if (hasCursor) break;
                SoundManager.playThrow(inSlot);
                break;
            }
            case field_7794: {
                if (!hasSlot) break;
                SoundManager.handleQuickMoveSound(inSlot);
                break;
            }
            default: {
                if (hasSlot) {
                    SoundManager.playSound(inSlot, SoundType.PICKUP);
                    break;
                }
                SoundManager.playSound(onCursor, SoundType.PLACE);
            }
        }
    }

    public static void handleInventorySlot(class_1657 player, @Nullable class_1735 slot, int slotIndex, class_1799 cursor, class_1713 actionType, int button) {
        class_1799 slotItem;
        if (actionType == class_1713.field_7789 && class_1703.method_7594((int)button) < 2) {
            return;
        }
        if (slotIndex == -1) {
            return;
        }
        class_1799 class_17992 = slotItem = slot == null ? class_1799.field_8037 : slot.method_7677().method_7972();
        if (actionType == class_1713.field_7794) {
            SoundManager.handleQuickMoveSound(slotItem);
            return;
        }
        class_1799 cursorItem = actionType == class_1713.field_7791 ? (class_1661.method_7380((int)button) ? player.method_31548().method_5438(button).method_7972() : player.method_6079().method_7972()) : cursor.method_7972();
        if (slotIndex == -999 && actionType != class_1713.field_7789) {
            if (RIGHT_CLICK_PREDICATE.test(actionType, button)) {
                cursorItem.method_7939(1);
            }
            SoundManager.playThrow(cursorItem);
            return;
        }
        if (actionType == class_1713.field_7795 && button == 0) {
            slotItem.method_7939(1);
        }
        try {
            BiPredicate predicateForCursor = IGNORE_SOUND_PREDICATE_MAP.getOrDefault(cursorItem.method_7909(), null);
            if (predicateForCursor != null && predicateForCursor.test(actionType, button)) {
                return;
            }
            BiPredicate predicateForSlot = IGNORE_SOUND_PREDICATE_MAP.getOrDefault(slotItem.method_7909(), null);
            if (predicateForSlot != null && predicateForSlot.test(actionType, button)) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SoundManager.inventoryClick(slotItem, cursorItem, actionType);
    }

    public static void playSound(class_1799 stack, SoundType type) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        class_2960 id = ExtraSoundsNext.getClickId(itemId, type);
        class_3414 event = SoundPackLoader.CUSTOM_SOUND_EVENT.getOrDefault(id, null);
        if (event == null) {
            SoundManager.playDefaultSound(stack, type);
            return;
        }
        SoundManager.playSound(event, type);
    }

    public static void playDefaultSound(class_1799 stack, SoundType type) {
        class_2960 defaultItem = ExtraSoundsNext.getClickId(class_7923.field_41178.method_10221((Object)class_1802.field_8477), type);
        class_2960 defaultBlock = ExtraSoundsNext.getClickId(class_7923.field_41178.method_10221((Object)class_1802.field_20391), type);
        class_3414 defaultSound = stack.method_7909() instanceof class_1747 ? SoundPackLoader.CUSTOM_SOUND_EVENT.get(defaultBlock) : SoundPackLoader.CUSTOM_SOUND_EVENT.get(defaultItem);
        SoundManager.playSound(defaultSound, type);
    }

    public static void effectChanged(class_1291 effect, EffectType type) {
        class_3414 event;
        if (DebugUtils.DEBUG) {
            DebugUtils.effectLog(effect, type);
        }
        if (type == EffectType.ADD) {
            event = switch (effect.method_18792()) {
                default -> throw new IncompatibleClassChangeError();
                case class_4081.field_18272 -> Sounds.EFFECT_ADD_NEGATIVE;
                case class_4081.field_18273, class_4081.field_18271 -> Sounds.EFFECT_ADD_POSITIVE;
            };
        } else if (type == EffectType.REMOVE) {
            event = switch (effect.method_18792()) {
                default -> throw new IncompatibleClassChangeError();
                case class_4081.field_18272 -> Sounds.EFFECT_REMOVE_NEGATIVE;
                case class_4081.field_18273, class_4081.field_18271 -> Sounds.EFFECT_REMOVE_POSITIVE;
            };
        } else {
            LOGGER.error("[{}] Unknown type of '{}' is approaching: '{}'", (Object)ExtraSoundsNext.class.getSimpleName(), (Object)EffectType.class.getSimpleName(), (Object)type);
            return;
        }
        SoundManager.playSound(event, SoundType.EFFECT, Mixers.ENABLED_EFFECTS);
    }

    public static void playSound(class_3414 snd, SoundType type) {
        SoundManager.playSound(snd, type.pitch, type.category, new class_3419[0]);
    }

    public static void playSound(class_3414 snd, SoundType type, class_3419 ... optionalVolumes) {
        SoundManager.playSound(snd, type.pitch, type.category, optionalVolumes);
    }

    public static void playSound(class_3414 snd, float pitch, class_3419 category, class_3419 ... optionalVolumes) {
        float volume = SoundManager.getSoundVolume(Mixers.MASTER, new boolean[0]);
        if (optionalVolumes != null) {
            for (class_3419 cat : optionalVolumes) {
                volume = Math.min(SoundManager.getSoundVolume(cat, new boolean[0]), volume);
            }
        }
        SoundManager.playSound((class_1113)new class_1109(snd == null ? ExtraSoundsNext.id("missing") : snd.method_14833(), category, volume, pitch, MC_RANDOM, false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
    }

    public static void playSound(class_3414 snd, SoundType type, float volume, float pitch, class_2338 position, class_3419 ... optionalVolumes) {
        SoundManager.playSound(snd, type, volume, pitch, position, false, optionalVolumes);
    }

    public static void playSound(class_3414 snd, SoundType type, float volume, float pitch, class_2338 position, boolean anti, class_3419 ... optionalVolumes) {
        if (optionalVolumes != null) {
            for (class_3419 cat : optionalVolumes) {
                volume = Math.min(SoundManager.getSoundVolume(cat, anti), volume * SoundManager.getSoundVolume(Mixers.MASTER, new boolean[0]));
            }
        }
        SoundManager.playSound((class_1113)new class_1109(snd, type.category, volume, pitch, MC_RANDOM, position));
    }

    public static void playSound(class_3414 snd, SoundType type, class_3419 enabledFootstep, class_2338 position) {
        SoundManager.playSound(snd, type, 1.0f, type.pitch, position, enabledFootstep);
    }

    public static void playSound(class_1113 instance) {
        try {
            long now = System.currentTimeMillis();
            if (now - lastPlayed > 5L) {
                class_310 client = class_310.method_1551();
                client.method_18858(() -> client.method_1483().method_4873(instance));
                lastPlayed = now;
                if (DebugUtils.DEBUG) {
                    DebugUtils.soundLog(instance);
                }
            } else if (DebugUtils.DEBUG) {
                LOGGER.warn("Sound suppressed due to the fast interval between method calls, was '{}'.", (Object)instance.method_4775());
            }
        }
        catch (Throwable e) {
            LOGGER.error("Failed to play sound", e);
        }
    }

    public static void playThrow(class_1799 itemStack) {
        SoundManager.playThrow(itemStack, Mixers.INVENTORY);
    }

    public static void playThrow(class_1799 itemStack, class_3419 category) {
        if (itemStack.method_7960()) {
            return;
        }
        float maxPitch = 2.0f;
        float pitch = !itemStack.method_7946() ? 2.0f : class_3532.method_37166((float)2.0f, (float)1.5f, (float)((float)itemStack.method_7947() / (float)itemStack.method_7909().method_7882()));
        SoundManager.playSound(Sounds.ITEM_DROP, pitch, category, Mixers.ITEM_DROP);
    }

    public static void stopSound(class_3414 e, SoundType type) {
        class_310.method_1551().method_1483().method_4875(e.method_14833(), type.category);
    }

    public static void handleQuickMoveSound(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - lastPlayed > 50L || !itemStack.method_31574(quickMovingItem)) {
            SoundManager.playSound(itemStack, SoundType.PICKUP);
            lastPlayed = now;
            quickMovingItem = itemStack.method_7909();
        }
    }

    public static void keyboard(KeyType type) {
        switch (type) {
            case ERASE: {
                SoundManager.playSound(Sounds.KEYBOARD_ERASE, SoundType.TYPING);
                break;
            }
            case CUT: {
                SoundManager.playSound(Sounds.KEYBOARD_CUT, SoundType.TYPING);
                break;
            }
            case CURSOR: 
            case RETURN: {
                SoundManager.playSound(Sounds.KEYBOARD_MOVE, SoundType.TYPING);
                break;
            }
            case INSERT: {
                SoundManager.playSound(Sounds.KEYBOARD_TYPE, SoundType.TYPING);
                break;
            }
            case PASTE: {
                SoundManager.playSound(Sounds.KEYBOARD_PASTE, SoundType.TYPING);
            }
        }
    }

    public static float getSoundVolume(class_3419 source, boolean ... anti) {
        float volume = class_310.method_1551().field_1690.method_1630(source);
        if (anti != null && anti.length > 0 && anti[0] && volume == 1.0f) {
            return 0.0f;
        }
        return volume;
    }

    public static enum EffectType {
        ADD,
        REMOVE;

    }

    public static enum KeyType {
        ERASE,
        CUT,
        INSERT,
        PASTE,
        RETURN,
        CURSOR;

    }
}

