/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mapping;

import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.debug.DebugUtils;
import dev.arbor.extrasoundsnext.mapping.SoundDefinition;
import dev.arbor.extrasoundsnext.mixin.misc.BucketFluidAccessor;
import dev.arbor.extrasoundsnext.sounds.Categories;
import dev.arbor.extrasoundsnext.sounds.Sounds;
import java.util.function.Function;
import net.minecraft.class_1110;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_3611;
import org.jetbrains.annotations.NotNull;

public final class SoundGenerator {
    public final String namespace;
    public final Function<class_1792, SoundDefinition> itemSoundGenerator;

    private SoundGenerator(String namespace, Function<class_1792, SoundDefinition> itemSoundGenerator) {
        this.namespace = namespace;
        this.itemSoundGenerator = itemSoundGenerator;
    }

    public static SoundGenerator of(@NotNull String namespace, @NotNull Function<class_1792, SoundDefinition> itemSoundGenerator) {
        return new SoundGenerator(namespace, itemSoundGenerator);
    }

    public static String getDescriptionId(class_1792 item) {
        String id = "";
        try {
            id = item.method_7876();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return id;
    }

    public static SoundDefinition getBucketItemSound(class_1755 bucketItem) {
        class_1110 soundEntry;
        try {
            class_3611 fluid = ((BucketFluidAccessor)bucketItem).getContent();
            soundEntry = fluid.method_32359().map(sound -> Sounds.event(sound.method_14833(), 0.4f)).orElse(Sounds.aliased(Categories.METAL));
        }
        catch (NullPointerException ignored) {
            soundEntry = Sounds.aliased(Categories.METAL);
        }
        return SoundDefinition.of(soundEntry);
    }

    public static class_2498 getSoundType(class_2248 block) {
        try {
            return block.method_9573(block.method_9564());
        }
        catch (Throwable e) {
            if (DebugUtils.DEBUG) {
                ExtraSoundsNext.LOGGER.error("Failed to get sound type for block {}", (Object)block, (Object)e);
            }
            return class_2498.field_11544;
        }
    }
}

