/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.annotation.fabric;

import dev.arbor.extrasoundsnext.ExtraSoundsNext;
import dev.arbor.extrasoundsnext.annotation.AddonFinder;
import dev.arbor.extrasoundsnext.annotation.SoundsGenerator;
import dev.arbor.extrasoundsnext.annotation.SoundsGeneratorFabic;
import dev.arbor.extrasoundsnext.mapping.DefaultAutoGenerator;
import dev.arbor.extrasoundsnext.mapping.SoundGenerator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;

public class AddonFinderImpl {
    public static List<Field> getAnnotatedFields() {
        List entrypointContainerList = FabricLoader.getInstance().getEntrypointContainers("sounds_generator", SoundsGeneratorFabic.class);
        LinkedHashSet<Field> annotatedFields = new LinkedHashSet<Field>();
        for (EntrypointContainer entrypointContainer : entrypointContainerList) {
            SoundsGeneratorFabic entrypoint = (SoundsGeneratorFabic)entrypointContainer.getEntrypoint();
            for (Field field : entrypoint.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(SoundsGenerator.class)) continue;
                if (!field.canAccess(null)) {
                    field.setAccessible(true);
                }
                annotatedFields.add(field);
            }
        }
        return new ArrayList<Field>(annotatedFields);
    }

    public static List<SoundGenerator> getSoundGenerators() {
        ArrayList<SoundGenerator> list = new ArrayList<SoundGenerator>();
        ArrayList namespaces = new ArrayList();
        HashMap soundGenerators = new HashMap();
        List<Field> fields = AddonFinder.getSoundsGenerators();
        if (fields.isEmpty()) {
            throw new RuntimeException("No sound generators found!");
        }
        fields.forEach(field -> {
            try {
                if (field.getType().equals(SoundGenerator.class)) {
                    SoundGenerator soundGenerator = (SoundGenerator)field.get(null);
                    soundGenerators.put(soundGenerator.namespace, soundGenerator.itemSoundGenerator);
                    ExtraSoundsNext.LOGGER.info("Loaded sound generator: {}", (Object)soundGenerator.namespace);
                }
            }
            catch (IllegalAccessException e) {
                ExtraSoundsNext.LOGGER.error("Failed to load field: {}", (Object)field.getName(), (Object)e);
            }
        });
        FabricLoader.getInstance().getAllMods().forEach(modContainer -> namespaces.add(modContainer.getMetadata().getId()));
        for (String namespace : namespaces) {
            list.add(SoundGenerator.of(namespace, soundGenerators.getOrDefault(namespace, DefaultAutoGenerator::autoGenerator)));
        }
        return list;
    }
}

